/*
 *  Copyright (c) 1990 Regents of the University of Michigan.
 *  All rights reserved.
 *
 *  open.c
 */

#ifndef lint 
static char copyright[] = "@(#) Copyright (c) 1990 Regents of the University of Michigan.\nAll rights reserved.\n";
#endif

#include "lber.h"
#include "ldap.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <Memory.h>
#include "macos.h"

#ifdef LDAP_DEBUG
int	ldap_debug;
#endif

/*
 * ldap_open - initialize and connect to an ldap server.  A magic cookie to
 * be used for future communication is returned on success, NULL on failure.
 *
 * Example:
 *	LDAP	*ld;
 *	ld = ldap_open( hostname, port );
 */

LDAP *ldap_open( host, port )
char	*host;
int	port;
{
	void			*tcps;
	short 			i;
	unsigned long	address;
    struct hostInfo	hi;
	char			*p;
	LDAP			*ld;

	Debug( LDAP_DEBUG_TRACE, "ldap_open\n", 0, 0, 0 );

	if ( gethostinfobyname( host, &hi ) != noErr ) {
		return( NULL );
	}

 	if ( port == 0 )
		port = LDAP_PORT;

	if (( tcps = tcpopen( NULL, TCP_BUFSIZ )) == NULL ) {
		Debug( LDAP_DEBUG_TRACE, "tcpopen failed\n", 0, 0, 0 );
		return( NULL );
	}

    for ( i = 0; hi.addr[ i ] != 0; ++i ) {
		(void) memcpy( (char *)&address, (char *)&hi.addr[ i ], sizeof( long ));
		if ( tcpconnect( tcps, address, port ) > 0 ) {
			break;
		}
	}
	
	if (  hi.addr[ i ] == 0 ) {
		tcpclose( tcps );
		Debug( LDAP_DEBUG_TRACE, "tcpconnect failed\n", 0, 0, 0 );
		return( NULL );
	}

	if ( (ld = (LDAP *) calloc( sizeof(LDAP), 1 )) == NULL ) {
		tcpclose( tcps );
		return( NULL );
	}
	ld->ld_sb.sb_sd = tcps;

#ifdef KERBEROS
	if ( gethostinfobyaddr( hi.addr[ i ], &hi ) == noErr ) {
		if (( p = strchr( hi.cname, '.' )) != NULL ) {
			*p = '\0';
		}
		ld->ld_host = strdup( hi.cname );
	} else {
		ld->ld_host = strdup( host );
	}
#endif KERBEROS

	ld->ld_version = LDAP_VERSION;

	return( ld );
}
