/* test.c - lber encoding test program */
/*
 * Copyright (c) 1990 Regents of the University of Michigan.
 * All rights reserved.
 */

#include <stdio.h>
#include <string.h>
#ifdef MACOS
#include <stdlib.h>
#include <unix.h>
#include <fcntl.h>
#include <console.h>
#endif /* MACOS */
#include "lber.h"

static usage( name )
char	*name;
{
	fprintf( stderr, "usage: %s [-i num]\n", name );
}

main( argc, argv )
int	argc;
char	**argv;
{
	int		i, num, len;
	Seqorset	*sos = NULLSEQORSET;
	BerElement	*ber;
	Sockbuf		sb;
	extern char	*optarg;

	sb.sb_sd = 1;
	sb.sb_ber.ber_buf = NULL;

#ifdef MACOS
	ccommand( &argv );
	cshow( stdout );

       if (( sb.sb_sd = open( "lber-test", O_WRONLY|O_CREAT|O_TRUNC|O_BINARY ))
		< 0 ) {
	    perror( "open" );
	    exit( 1 );
	}
#endif /* MACOS */

	if ( (ber = ber_alloc()) == NULLBER ) {
		perror( "ber_alloc" );
		exit( 1 );
	}

	num = atoi( argv[1] );
fprintf( stderr, "num is 0x%x\n", num );
	if ( ber_printf( ber, "{i}", num ) == -1 ) {
		fprintf( stderr, "ber_printf returns -1" );
		exit( 1 );
	}

	if ( ber_flush( &sb, ber, 1 ) == -1 ) {
		perror( "ber_flush" );
		exit( 1 );
	}

	exit( 0 );

	while ( (i = getopt( argc, argv, "b:e:i:no:s:" )) != EOF ) {
		switch ( i ) {
		case 'b':	/* encode a boolean value */
			num = atoi( optarg );
			if ( (len = ber_put_boolean( ber, num, -1, sos ))
			    == -1 )
				perror( "ber_putboolean" );
			else
				fprintf( stderr, "wrote %d bytes\n", len );
			break;

		case 'i':	/* encode an integer */
			num = atoi( optarg );
			if ( (len = ber_put_int( ber, num, -1, sos )) == -1 )
				perror( "ber_putint" );
			else
				fprintf( stderr, "wrote %d bytes\n", len );
			break;

		case 'n':	/* encode a null */
			if ( (len = ber_put_null( ber, -1, sos )) == -1 )
				perror( "ber_putnull" );
			else
				fprintf( stderr, "wrote %d bytes\n", len );
			break;

		case 'o':	/* encode an octet string */
			if ( (len = ber_put_string( ber, optarg, -1, sos ))
			    == -1 )
				perror( "ber_putstring" );
			else
				fprintf( stderr, "wrote %d bytes\n", len );
			break;

		case 's':	/* start to encode set or sequence */
			/* sequence */
			if ( strcmp( optarg, "eq" ) == 0 ) {
				if ( ber_start_seq( ber, -1, &sos ) == -1 )
					perror( "ber_startseq" );

			/* set */
			} else if ( strcmp( optarg, "et" ) == 0 ) {
				if ( ber_start_set( ber, -1, &sos ) == -1 )
					perror( "ber_startset" );
			} else {
				usage( argv[0] );
			}
			break;

		case 'e':	/* end of set or sequence */
			/* sequence */
			if ( strcmp( optarg, "seq" ) == 0 ) {
				if ( (len = ber_put_seq( &sos )) == -1 )
					perror( "ber_end_seq" );
				else
					fprintf( stderr, "wrote %d bytes\n",
					    len );
			/* set */
			} else if ( strcmp( optarg, "set" ) == 0 ) {
				if ( (len = ber_put_set( &sos )) == -1 )
					perror( "ber_end_set" );
				else
					fprintf( stderr, "wrote %d bytes\n",
					    len );
			} else {
				usage( argv[0] );
			}
			break;

		default:
			break;
		}
	}

	if ( ber_flush( &sb, ber, 1 ) == -1 ) {
		perror( "ber_flush" );
		exit( 1 );
	}

	return( 0 );
}
