/*
 * Copyright (c) 1990 Regents of the University of Michigan.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and that due credit is given
 * to the University of Michigan at Ann Arbor. The name of the University
 * may not be used to endorse or promote products derived from this
 * software without specific prior written permission. This software
 * is provided ``as is'' without express or implied warranty.
 */

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include "lber.h"
#include "ldap.h"
#include "common.h"

static struct msg	*messages;

struct msg *add_msg( msgid, msgtype, ber, dsaconn )
int		msgid;
int		msgtype;
BerElement	*ber;
struct conn	*dsaconn;
{
	struct msg		*new;

	/* make a new message */
	if ( (new = (struct msg *) malloc( sizeof(struct msg) )) == NULL ) {
		Debug( LDAP_DEBUG_ANY, "addmsg: malloc failed\n", 0, 0, 0 );
		return( NULL );
	}
	new->m_msgid = msgid;
	new->m_msgtype = msgtype;
	new->m_ber = ber;
	new->m_mods = NULL;
	new->m_conn = dsaconn;
	new->m_conn->c_refcnt++;
	new->m_next = NULL;

	/* add it to the front of the queue */
	new->m_next = messages;
	messages = new;

	return( new );
}

struct msg *get_msg( msgid )
int	msgid;
{
	struct msg	*tmp;

	for ( tmp = messages; tmp != NULL; tmp = tmp->m_next ) {
		if ( tmp->m_msgid == msgid )
			return( tmp );
	}

	return( NULL );
}

del_msg( msgid )
int	msgid;
{
	struct msg	*cur, *prev;

	prev = NULL;
	for ( cur = messages; cur != NULL; cur = cur->m_next ) {
		if ( cur->m_msgid == msgid )
			break;
		prev = cur;
	}

	if ( cur == NULL ) {
		Debug( LDAP_DEBUG_ANY, "delmsg: cannot find msg %d\n", msgid,
		    0, 0 );
		return( -1 );
	}

	if ( prev == NULL ) {
		messages = cur->m_next;
	} else {
		prev->m_next = cur->m_next;
	}
	conn_free( cur->m_conn );
	modlist_free( cur->m_mods );
	ber_free( cur->m_ber, 1 );
	free( (char *) cur );

	return( 0 );
}

/*
 * send_msg - Send a messge in response to every outstanding request on
 * a given connection.  This is used, for example, when an association to
 * a dsa fails.  It deletes messages to which it responds.
 */

send_msg( conn, clientsb, err, str )
struct conn	*conn;
Sockbuf		*clientsb;
int		err;
char		*str;
{
	struct msg	*tmp, *next;

	next = NULL;
	for ( tmp = messages; tmp != NULL; tmp = next ) {
		next = tmp->m_next;

		if ( tmp->m_conn == conn ) {
			send_ldap_result( clientsb, tmp->m_msgtype,
			    tmp->m_msgid, err, str );
		}

		del_msg( tmp->m_msgid );
	}
}
