/*
 * lber-proto.h
 * function prototypes for lber library
 */
#ifdef LDAP_DEBUG
extern int lber_debug;
#endif
/*
 * in bprint.c:
 */
int lber_bprint( char *data, int len );

/*
 * in decode.c:
 */
int ber_skip_tag( BerElement *ber, unsigned long *len );
int ber_peek_tag( BerElement *ber, unsigned long *len );
int ber_get_int( BerElement *ber, long *num );
int ber_get_stringb( BerElement *ber, char *buf, unsigned long *len );
int ber_get_stringa( BerElement *ber, char **buf );
int ber_get_stringal( BerElement *ber, struct berval **bv );
int ber_get_bitstringa( BerElement *ber, char **buf, unsigned long *len );
int ber_get_null( BerElement *ber );
int ber_get_boolean( BerElement *ber, int *bool );
int ber_first_element( BerElement *ber, unsigned long *len, char **last );
int ber_next_element( BerElement *ber, unsigned long *len, char *last );
#ifdef MACOS
int ber_scanf( BerElement *ber, char *fmt, ... );
#else /* MACOS */
int ber_scanf();
#endif /* MACOS */
int ber_bvfree( struct berval *bv );
int ber_bvecfree( struct berval **bv );

/*
 * in encode.c
 */
int ber_put_enum( BerElement *ber, long num, char tag );
int ber_put_int( BerElement *ber, long num, char tag );
int ber_put_ostring( BerElement *ber, char *str, unsigned long len, char tag );
int ber_put_string( BerElement *ber, char *str, char tag );
int ber_put_bitstring( BerElement *ber, char *str, unsigned long bitlen,
	char tag );
int ber_put_null( BerElement *ber, char tag );
int ber_put_boolean( BerElement *ber, int bool, char tag );
int ber_start_seq( BerElement *ber, char tag );
int ber_start_set( BerElement *ber, char tag );
int ber_put_seq( BerElement *ber );
int ber_put_set( BerElement *ber );
#ifdef MACOS
int ber_printf( BerElement *ber, char *fmt, ... );
#else /* MACOS */
int ber_printf();
#endif /* MACOS */

/*
 * in io.c:
 */
long ber_read( BerElement *ber, char *buf, unsigned long len );
long ber_write( BerElement *ber, char *buf, unsigned long len, int nosos );
void ber_free( BerElement *ber, int freebuf );
int ber_flush( Sockbuf *sb, BerElement *ber, int freeit );
BerElement *ber_alloc( void );
BerElement *ber_dup( BerElement *ber );
int ber_dump( BerElement *ber, int inout );
int ber_sos_dump( Seqorset *sos );
int ber_get_next( Sockbuf *sb, unsigned long *len, BerElement	*ber );

#ifdef NEEDGETOPT
/*
 * in getopt.c
 */
int getopt( int nargc, char **nargv, char *ostr );
#endif /* NEEDGETOPT */
