/*
    This file is part of the FElt finite element analysis package.
    Copyright (C) 1993 Jason I. Gobat and Darren C. Atkinson

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

# ifndef _OBJECTS_H
# define _OBJECTS_H
# include "fe.h"

# if defined (__STDC__) || defined (__GNUC__)

extern Distributed CreateDistributed  (char *, unsigned);
extern void        DestroyDistributed (Distributed);

extern Force       CreateForce        (char *);
extern void        DestroyForce       (Force);

extern Constraint  CreateConstraint   (char *);
extern void        DestroyConstraint  (Constraint);

extern Material    CreateMaterial     (char *);
extern void        DestroyMaterial    (Material);

extern Node        CreateNode         (unsigned);
extern void        DestroyNode        (Node);

extern Element     CreateElement      (unsigned, Definition);
extern void        DestroyElement     (Element);

# else

extern Distributed CreateDistributed  ( );
extern void        DestroyDistributed ( );

extern Force       CreateForce        ( );
extern void        DestroyForce       ( );

extern Constraint  CreateConstraint   ( );
extern void        DestroyConstraint  ( );

extern Material    CreateMaterial     ( );
extern void        DestroyMaterial    ( );

extern Node        CreateNode         ( );
extern void        DestroyNode        ( );

extern Element     CreateElement      ( );
extern void        DestroyElement     ( );

# endif

# endif /* _OBJECTS_H */
