/*
    This file is part of the FElt finite element analysis package.
    Copyright (C) 1993 Jason I. Gobat and Darren C. Atkinson

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*************************************************************************
*
* File:		definitions.h
*
* Description:	contains information to describe the gui for xfelt 
*		(menu members, buttons, forms, etc.)
*
* Note:		This isn't exactly the traditional way to organize
*		all this stuff, but it keeps xfelt.c from getting
*		way out of hand.  This file should ONLY be included
*		by xfelt.c (essentially, it's a part of that file, not
*		a traditional header file).
*
**************************************************************************/

# ifndef _DEFINITIONS_H
# define _DEFINITIONS_H

/* The control panel */

Panel panel [ ] = {
    {"file", &menuButtonWidgetClass, 6,
	{{"load", Load}, {"save", Save}, {"save_as", SaveAs},
	{"print", Print}, {"new", New}, {"exit",Exit}}},

    {"edit", &menuButtonWidgetClass, 3,
	{{"cut", Cut}, {"copy", Copy}, {"paste", Paste}}},

    {"setup", &menuButtonWidgetClass, 2, 
        {{"options", Options}, {"configure", Configure}}},

    {"run",	    &commandWidgetClass, 0, {{"", Run}}},

    {"info",	    &commandWidgetClass, 0, {{"", Info}}},
};

/* 
 * The default translations.  
 */

char default_translations [ ] = 
   "Meta<Key>q:     Quit()\n\
    Meta<Key>r:     ExecuteFelt()\n\
    Meta<Key>2:	    FlipDrawToggle(2)\n\
    Meta<Key>3:     FlipDrawToggle(3)\n\
    Shift<Key>BackSpace: ZapText() \n\
    Meta<Key>I: no-op() \n\
    Ctrl<Key>S: no-op() \n\
    Ctrl<Key>R: no-op() \n\
    Ctrl<Key>W: CopyText() \n\
    Ctrl<Key>Y: PasteText() \n\
    Meta<Key>W: CutText() \n\
    Meta<Key>Y: no-op() \n\
    <Btn2Down>: no-op() \n\
    <Key>Delete: delete-next-character()"; 

/* and some actions to go along with them */

XtActionsRec actiontable [ ] = {
   {"Quit", Quit},
   {"ExecuteFelt", ExecuteFelt},
   {"FlipDrawToggle", FlipDrawToggle},
   {"ZapText", ZapText},
   {"CopyText", CopyText},
   {"PasteText", PasteText},
   {"CutText", CutText},
};


ToggleRecord option_entries = {
   4, NULL, {"no pre-processor","material summary","draw structure (2d)",
             "draw structure (3d)"}
};

EntryRecord setup_entries = {
   4, {{"command to execute Felt", TEXT_AND_NUMERIC},
       {"command to print text",TEXT_AND_NUMERIC},
       {"command to print graphics",TEXT_AND_NUMERIC},
       {"command to convert an XWD image", TEXT_AND_NUMERIC}}
};

# endif
