/*
 * Copyright (c) 1992, 1993  Regents of the University of Michigan.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and that due credit is given
 * to the University of Michigan at Ann Arbor. The name of the University
 * may not be used to endorse or promote products derived from this
 * software without specific prior written permission. This software
 * is provided ``as is'' without express or implied warranty.
 */

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <lber.h>
#include <ldap.h>
#include "ud.h"

#ifdef DEBUG
extern int debug;
#endif

print_help(s)
char *s;
{
	char *cp;		/* misc char ptr */
	char cmd[BUFSIZ];	/* buffer to hold command */
	int len;			/* command length */

#ifdef DEBUG
	if (debug & D_TRACE)
		printf("->print_help(%s)\n", s);
#endif
	cp = cmd;
	while (!isspace(*s) && (*s != '\0')) {
		*cp++ = *s++;
	}
	*cp = '\0';
	len = strlen(cmd);

	/* print general help, or just on topic 's' if provided */
	if ((cmd[0] == '\0') || !strncasecmp("commands", cmd, (len > 2) ? len : 2)) {
		printf("\n  Here are brief descriptions of available commands:\n\n");
		printf("  ?                    To print this list.\n");
		printf("  bind                 To bind (authenticate) to the Directory.\n");
		printf("  cb                   To change the search base.\n");
		printf("  change [group]       To change information associated with an entry.\n");
		printf("  create               To create a new group entry in the Directory\n");
		printf("  find                 To find an entry in the Directory\n");
		printf("  groupbase            To change the group base.\n");
		printf("  help                 To print this list.\n");
		printf("  join                 To subscribe to a group in the Directory.\n");
		printf("  purge                To remove obsolete entries from a group\n");
		printf("  quit                 To terminate the program.\n");
		printf("  remove               To remove a group entry from the Directory.\n");
		printf("  resign               To unsubscribe from group in the Directory.\n");
		printf("  tidy                 To unsubscribe from groups that no longer exist.\n");
		printf("  verbose              To toggle the verbose switch.\n");

		printf("\n  Type \"help <command-name>\" to get help about a particular command.\n\n");
	}
	else if (!strncasecmp("status", cmd, len)) {
		printf("  status\n\n");
		format("Prints out the current connection status.  Lists the name of the current LDAP server, the current search base, the current group base, and the identity to which you are bound.  If you have not bound as anyone then ud considers you bound as Nobody.  cd is an alias for cb.", 75, 2);
	}
	else if (!strncasecmp("groupbase", cmd, len)) {
		printf("  groupbase\n\n");
		format("The syntax and use of this command is identical to the more commonly used 'cb' command.  This command sets the base which is used to create groups in the X.500 Directory.  Setting the base to a certain value does not necessarily grant the user write-access to that part of the Directory in order to successfully create a group.", 75, 2);
	}
	else if (!strncasecmp("cd", cmd, len) || !strncasecmp("cb", cmd,len)) {
		printf("  cb <new-base>\n");
		printf("  cd <new-base>\n\n");
		format("The cb command changes the search base.  By default, this program looks only in the local part of the Directory.  By using the cb command, you can search other parts of the Directory.", 75, 2);
	printf("\n  Examples:\n");
	printf("\n            * cb ..\n\n");
	format("changes the search base so that it is one level higher in the Directory.  Note that if you perform several of these in a row you will move to the root of the Directory tree.", 75, 2);
	printf("\n            * cb ?\n\n");
	format("prints out a list of the possible areas to search below the current search base.  This is useful once you have moved high in the tree and wish to snoop about.", 75, 2);
	printf("\n            * cb default\n\n");
	format("sets the search base to its original default value.", 75, 2);
	printf("\n            * cb o=Merit Computer Network, c=US\n\n");
	format("sets the search base to organization given, the Merit Computer Network in this case.  This comamnd checks the validity of the specified search base, and rejects it if it is not a valid Distinguished Name (DN).  A DN uniquely identifies a portion of the global X.500 namespace.", 75, 2);
	}
	else if (!strncasecmp("quit", cmd, len) || !strncasecmp("stop",cmd, len)) {
		printf("  quit\n");
		printf("  stop\n\n");
		printf("  Quits the program.  'stop' is an alias for 'quit'.\n");
	}
	else if (!strncasecmp("find", cmd, len) || !strncasecmp("display", cmd, len) || !strncasecmp("show", cmd, len)) {
		printf("  find <who>\n");
		printf("  show <who>\n");
		printf("  display <who>\n\n");
		format("Displays information about the person specified.  If the name specified matches more than one person, one will be presented a list from which to make a choice.  'show' and 'display' are aliases for 'find.'", 75, 2);
	}
	else if (!strncasecmp("bind", cmd, len)) {
		printf("  bind [who]\n\n");
		format("Binds (authenticates) to the Directory.  It is generally necessary to bind to the Directory in order to look at privileged entries or to modify an entry.   Allows one to authenticate prior to issuing a 'change' or 'modify' command.  Most often used by administrators to bind to an identity.", 75, 2);
	}
	else if (!strncasecmp("modify", cmd, len) || !strncasecmp("change", cmd, len)) {
		printf("  modify [who]\n");
		printf("  change [who]\n\n");
		format("Changes information associated with an entry in the X.500 Directory.  'change' is an alias for 'modify'.", 75, 2);
	}
	else if (!strncasecmp("iam", cmd, len)) {
		printf("  iam <name>\n\n");
		format("Sets your name so that the word 'me' may be used as a legal identifier when issuing other commands.  For instance, after issuing a 'iam John Doe' command, one could then issue a 'display me' command instead of having to type 'display John Doe.'", 75, 2);
	}
	else if (!strncasecmp("whoami", cmd, len)) {
		printf("  whoami\n\n");
		format("Prints the name set with the 'iam' command.", 75, 2);
	}
	else if (!strncasecmp("verbose", cmd, len)) {
		printf("  verbose\n\n");
		format("Turns on long and windy messages which might be useful to new users of this program.  If verbose mode is already on, this turns it off.", 75, 2);
	}
	else if (!strncasecmp("create", cmd, len)) {
		printf("  create\n\n");
		format("Creates a new group in the Directory.", 75, 2);
	}
	else if (!strncasecmp("join", cmd, len) || !strncasecmp("subscribe", cmd, len)) {
		printf("  join [group]\n");
		printf("  subscribe [group]\n\n");
		format("Adds the user as a subscriber to the specified group.", 75, 2);
	}
	else if (!strncasecmp("purge", cmd, len)) {
		printf("  purge\n\n");
		format("Goes through the specified group looking for Distinguished Names that cannot be found.  As it finds each one, it gives the user an opportunity to delete it.", 75, 2);
	}
	else if (!strncasecmp("resign", cmd, len) || !strncasecmp("unsubscribe", cmd, len)) {
		printf("  resign [group]\n");
		printf("  unsubscribe [group]\n\n");
		format("Deletes the user from the specified group.", 75, 2);
	}
	else if (!strncasecmp("remove", cmd, len)) {
		printf("  remove\n\n");
		format("Removes a group from the Directory.", 75, 2);
	}
	else if (!strncasecmp("help", cmd, len)) {
		format("Prints out a brief description of each command.", 75, 2);
	}
	else if (!strncasecmp("tidy", cmd, len)) {
		printf("  tidy\n\n");
		format("Unsubscribes you from non-existent groups.  Useful when you cannot resign from a group because, while your X.500 entry still contains a pointer to it, someone has removed a group of which you were a subscriber.", 75, 2);
	}
	else if (cmd[0] == '?') {
		format("Prints out a brief description of each command.  Same as typing 'help help'.", 75, 2);
	}
	else {
		printf("  Don't recognize <%s>\n", cmd);
	}
}
