/*
 * rcpt500.h: includes for rcpt500 (X.500 email query responder)
 *
 * 16 June 1992 by Mark C Smith
 * Copyright (c) 1992 The Regents of The University of Michigan
 * All Rights Reserved
 */

/*
 **** change these for your local site ****
 */
/*
 * FROM is the address replies from this program will appear to come from
 */
#define FROM		"\"X.500 Query Program\" <X500-Query>"

/*
 * PIPEMAILCMD is a command that will accept RFC822 message text on its
 * standard input, parse the message, and send it to the receipients
 * list in the "To:" header.  sendmail -t does the job nicely.
 */
#define PIPEMAILCMD	"/usr/lib/sendmail -t"

/*
 * HELPATH is the full path name to read the help command reply text from
 */
#define HELPPATH	"/usr/local/etc/rcpt500.help"

/*
 * where the filter configuration file lives
 */
#define _DEF_FILTERCONF      "/usr/local/etc/ldapfilter.conf"

/*
 * all of the following _DEF* variables can be overridden on the rcpt500
 * command line, but you can also change them here:
 * _DEF_DAPUSER is the DN the program binds as (useful for logging, but
 *    you can set it to NULL
 * _DEF_SEARCHBASE is the starting point of searches done by rcpt500
 * _DEF_LDAPHOST is the hostname of the LDAP server to connect to
 * _DEF_SIZELIMIT is the limit on the number of entries returned
 * _DEF_STRIPCOUNT is the number of DN components to be removed when
 *    printing the user friendly name of the entry returned
 */
#define _DEF_DAPUSER	"cn=Rcpt500,ou=Miscellaneous Servers,o=University of Michigan,c=US"
#define _DEF_SEARCHBASE	"o=University of Michigan,c=US"
#define _DEF_LDAPHOST	"localhost"
#define _DEF_SIZELIMIT	50
#define _DEF_STRIPCOUNT	3


/*
 ****
 **** you should not need to change anything below here ****
 ****
 */
struct msginfo {
    char	*msg_subject;
    char	*msg_replyto;	/* actually could be from From: line */
    char	*msg_date;
    char	*msg_messageid;
    int		msg_command;
    char	*msg_arg;
};

struct command {
    char        *cmd_text;              /* text for command, e.g. "HELP" */
    int        (*cmd_handler)();        /* pointer to handler function */
};


#define MAXSIZE		8096


/*
 * functions
 */
int	help_cmd();
int	query_cmd();

/*
 * externs
 */
extern struct command cmds[];
