/*
 *  Copyright (c) 1992 Regents of the University of Michigan.
 *  All rights reserved.
 *
 *  kerberos-macos.c
 */

#ifndef lint 
static char copyright[] = "@(#) Copyright (c) 1992 Regents of the University of Michigan.\nAll rights reserved.\n";
#endif

#include "lber.h"
#include "ldap.h"

#ifdef KERBEROS

#include <stdio.h>
#include <string.h>
#include <pascal.h>
#ifdef AUTHMAN
#include <Errors.h>
#include "authLibrary.h"

/*
 * get_kerberosv4_credentials - obtain kerberos v4 credentials for ldap.
 */

/* ARGSUSED */
char *get_kerberosv4_credentials( ld, who, passwd, service, len )
LDAP	*ld;
char	*who;
char	*passwd;
char	*service;
int	*len;
{
	static short	authman_refnum = 0;
	static			char *ticket[ MAX_KTXT_LEN ];
	short			version, ticketlen, err;
	Str255			svcps, instps;
	
	/*
	 * make sure RJC's Authentication Manager 2.0 or better is available
	 */
	if ( authman_refnum == 0 && (( err = openAuthMan( &authman_refnum, &version )) != noErr || version < 2 )) {
		authman_refnum = 0;
		ld->ld_errno = LDAP_AUTH_UNKNOWN;
		return( NULL );
	}
	
	strcpy( (char *)svcps, service );
	CtoPstr( (char *)svcps );
	strcpy( (char *)instps, ld->ld_host );
	CtoPstr( (char *)instps );
	if (( err = getV4Ticket( authman_refnum, &ticket, &ticketlen, &svcps, &instps,
			NULL, INFINITE_LIFETIME, 1 )) != noErr ) {
		ld->ld_errno = ( err == userCanceledErr ) ?
			LDAP_USER_CANCELLED : LDAP_INVALID_CREDENTIALS;
		return( NULL );
	}

	*len = ticketlen;
	return( (char *)ticket );
}

#endif
#endif
