/*
 *  Copyright (c) 1990 Regents of the University of Michigan.
 *  All rights reserved.
 *
 *  open.c
 */

#ifndef lint 
static char copyright[] = "@(#) Copyright (c) 1990 Regents of the University of Michigan.\nAll rights reserved.\n";
#endif

#include "lber.h"
#include "ldap.h"
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

#ifndef INADDR_LOOPBACK
#define INADDR_LOOPBACK	((u_long) 0x7f000001)
#endif

#ifdef LDAP_DEBUG
int	ldap_debug;
#endif

/*
 * ldap_open - initialize and connect to an ldap server.  A magic cookie to
 * be used for future communication is returned on success, NULL on failure.
 *
 * Example:
 *	LDAP	*ld;
 *	ld = ldap_open( hostname, port );
 */

LDAP *ldap_open( host, port )
char	*host;
int	port;
{
	int 			s, use_hp, i, rc;
	unsigned long		address;
	struct sockaddr_in 	sock;
	struct hostent		*hp;
	LDAP			*ld;
	char			*p, hostname[BUFSIZ];

	Debug( LDAP_DEBUG_TRACE, "ldap_open\n", 0, 0, 0 );

	if ( port == 0 )
		port = LDAP_PORT;

	use_hp = 0;

	if ( host != NULL ) {
		if ( (address = inet_addr( host )) == -1 ) {
			if ( (hp = gethostbyname( host )) == NULL ) {
				perror( "gethostbyname" );
				return( NULL );
			}
			use_hp = 1;
		}
	} else {
		address = htonl( INADDR_LOOPBACK );
	}

	for ( rc = -1, i = 0; !use_hp || ( hp->h_addr_list[ i ] != 0 ); i++ ) {
	    if ( (s = socket( AF_INET, SOCK_STREAM, 0 )) < 0 )
		    return( NULL );

	    (void )memset( (char *)&sock, 0, sizeof( struct sockaddr_in ));
	    sock.sin_family = AF_INET;
	    sock.sin_port = htons( port );
	    (void) memcpy( (char *) &sock.sin_addr.s_addr,
		( use_hp ? (char *) hp->h_addr_list[ i ] : (char *) &address ),
		sizeof( sock.sin_addr.s_addr) );

	    if (( rc = connect( s, (struct sockaddr *) &sock,
		sizeof(sock) )) >= 0 || !use_hp ) {
		    break;
	    }
	    close( s );
	}

	if ( rc < 0 ) {
	    return( NULL );
	}

	/*
	 * do a reverse lookup on the addr to get the official hostname.
	 * this is necessary for kerberos to work right, since the official
	 * hostname is used as the kerberos instance.
	 */

	hostname[0] = '\0';
	if ( (hp = gethostbyaddr( (char *) &sock.sin_addr.s_addr,
	    sizeof( sock.sin_addr.s_addr ), AF_INET )) != NULL ) {
		if ( hp->h_name != NULL ) {
			if ( (p = strchr( hp->h_name, '.' )) != NULL )
				*p = '\0';
			strcpy( hostname, hp->h_name );
		}
	}



	if ( (ld = (LDAP *) calloc( sizeof(LDAP), 1 )) == NULL ) {
		close( s );
		return( NULL );
	}
	ld->ld_sb.sb_sd = s;
	ld->ld_host = strdup( hostname );
	ld->ld_version = LDAP_VERSION;

	return( ld );
}
