/*
 *  Copyright (c) 1990 Regents of the University of Michigan.
 *  All rights reserved.
 *
 *  abandon.c
 */

#ifndef lint 
static char copyright[] = "@(#) Copyright (c) 1990 Regents of the University of Michigan.\nAll rights reserved.\n";
#endif

#ifdef DOS
#include <malloc.h>
#include "msdos.h"
#endif /* DOS */

#include "lber.h"
#include "ldap.h"
#include <stdio.h>
#include <string.h>
#ifdef MACOS
#include <stdlib.h>
#include "macos.h"
#endif /* MACOS */

/*
 * ldap_abandon - perform an ldap (and X.500) abandon operation. Parameters:
 *
 *	ld		LDAP descriptor
 *	msgid		The message id of the operation to abandon
 *
 * ldap_abandon returns 0 if everything went ok, -1 otherwise.
 *
 * Example:
 *	ldap_abandon( ld, msgid );
 */

ldap_abandon( ld, msgid )
LDAP	*ld;
int	msgid;
{
	BerElement	*ber;
	int		i;

	/*
	 * An abandon request looks like this:
	 *	AbandonRequest ::= MessageID
	 */

	Debug( LDAP_DEBUG_TRACE, "ldap_abandon %d\n", msgid, 0, 0 );

	if ( ldap_msgdelete( ld, msgid ) == 0 ) {
		ld->ld_errno = LDAP_SUCCESS;
		return( 0 );
	}

	/* create a message to send */
	if ( (ber = ber_alloc()) == NULLBER ) {
		ld->ld_errno = LDAP_LOCAL_ERROR;
		return( -1 );
	}

	if ( ber_printf( ber, "{it{i}}", ++ld->ld_msgid, LDAP_REQ_ABANDON,
	    msgid ) == -1 ) {
		ld->ld_errno = LDAP_ENCODING_ERROR;
		ber_free( ber, 1 );
		return( -1 );
	}

	/* send the message */
	if ( ber_flush( &ld->ld_sb, ber, 1 ) != 0 ) {
		ld->ld_errno = LDAP_SERVER_DOWN;
		return( -1 );
	}

	if ( ld->ld_abandoned == NULL ) {
		ld->ld_abandoned = (int *) malloc( 2 * sizeof(int) );
		i = 0;
	} else {
		for ( i = 0; ld->ld_abandoned[i] != -1; i++ )
			;	/* NULL */
		ld->ld_abandoned = (int *) realloc( (char *) ld->ld_abandoned,
		    (i + 2) * sizeof(int) );
	}
	ld->ld_abandoned[i] = msgid;
	ld->ld_abandoned[i + 1] = -1;

	ld->ld_errno = LDAP_SUCCESS;
	return( 0 );
}
