/*
 * ldap-proto.h
 * function prototypes for ldap library
 */
/*
 * in abandon.c:
 */
int ldap_abandon( LDAP *ld, int msgid );

/*
 * in add.c:
 */
int ldap_add( LDAP *ld, char *dn, LDAPMod **attrs );
int ldap_add_s( LDAP *ld, char *dn, LDAPMod **attrs );

/*
 * in bind.c:
 */
int ldap_bind( LDAP *ld, char *who, char *passwd, int authmethod );
int ldap_bind_s( LDAP *ld, char *who, char *cred, int method );
int ldap_simple_bind( LDAP *ld, char *who, char *passwd );
int ldap_simple_bind_s( LDAP *ld, char *who, char *passwd );
int ldap_kerberos_bind( LDAP *ld, char *who, char *passwd );
int ldap_kerberos_bind_s( LDAP *ld, char *who, char *passwd );
int ldap_kerberos_bind1( LDAP *ld, char *who, char *passwd );
int ldap_kerberos_bind1_s( LDAP *ld, char *who, char *passwd );
int ldap_kerberos_bind2( LDAP *ld, char *who, char *passwd );
int ldap_kerberos_bind2_s( LDAP *ld, char *who, char *passwd );
int ldap_unbind( LDAP *ld );

/*
 * in cache.c
 */
int ldap_enable_cache( LDAP *ld, long timeout, long maxmem );
void ldap_disable_cache( LDAP *ld );
void ldap_destroy_cache( LDAP *ld );
void ldap_flush_cache( LDAP *ld );
void ldap_uncache_entry( LDAP *ld, char *dn );
void add_request_to_cache( LDAP *ld, int msgtype, BerElement *request );
void add_result_to_cache( LDAP *ld, LDAPMessage *result );
int check_cache( LDAP *ld, int msgtype, BerElement *request );

/*
 * in compare.c:
 */
int ldap_compare( LDAP *ld, char *dn, char *attr, char *value );
int ldap_compare_s( LDAP *ld, char *dn, char *attr, char *value );

/*
 * in delete.c:
 */
int ldap_delete( LDAP *ld, char *dn );
int ldap_delete_s( LDAP *ld, char *dn );

/*
 * in error.c:
 */
int ldap_result2error( LDAP *ld, LDAPMessage *r, int freeit );
char *ldap_err2string( int err );
void ldap_perror( LDAP *ld, char *s );

/*
 * in modify.c:
 */
int ldap_modify( LDAP *ld, char *dn, LDAPMod **mods );
int ldap_modify_s( LDAP *ld, char *dn, LDAPMod **mods );

/*
 * in modrdn.c:
 */
int ldap_modrdn( LDAP *ld, char *dn, char *newrdn );
int ldap_modrdn_s( LDAP *ld, char *dn, char *newrdn );

/*
 * in open.c:
 */
LDAP *ldap_open( char *host, int port );

/*
 * in parse.c:
 */
LDAPMessage *ldap_first_entry( LDAP *ld, LDAPMessage *chain );
LDAPMessage *ldap_next_entry( LDAP *ld, LDAPMessage *entry );
LDAPMessage *ldap_delete_result_entry( LDAPMessage **list, LDAPMessage *e );
void ldap_add_result_entry( LDAPMessage **list, LDAPMessage *e );
char *ldap_get_dn( LDAP *ld, LDAPMessage *entry );
char *ldap_dn2ufn( char *dn );
char *ldap_first_attribute( LDAP *ld, LDAPMessage *entry, BerElement **ber );
char *ldap_next_attribute( LDAP *ld, LDAPMessage *entry, BerElement *ber );
char **ldap_get_values( LDAP *ld, LDAPMessage *entry, char *target );
struct berval **ldap_get_values_len( LDAP *ld, LDAPMessage *entry, char *target );
int ldap_count_entries( LDAP *ld, LDAPMessage *chain );
int ldap_count_values( char **vals );
void ldap_value_free( char **vals );
char **ldap_explode_dn( char *dn, int notypes );

/*
 * in result.c:
 */
int ldap_result( LDAP *ld, int msgid, int all, struct timeval *timeout,
			LDAPMessage **result );
int ldap_msgfree( LDAPMessage *lm );
int ldap_msgdelete( LDAP *ld, int msgid );

/*
 * in search.c:
 */
int ldap_search( LDAP *ld, char *base, int scope, char *filter, char **attrs,
			int attrsonly );
int ldap_search_s( LDAP *ld, char *base, int scope, char *filter,
	char **attrs, int attrsonly, LDAPMessage **res );
int ldap_search_st( LDAP *ld, char *base, int scope, char *filter,
    char **attrs, int attrsonly, struct timeval *timeout, LDAPMessage **res );

/*
 * in ufn.c
 */
int ldap_ufn_search_c( LDAP *ld, char *ufn, char **attrs, int attrsonly,
	LDAPMessage **res, int (*cancelproc)( long cl ), long cancellong );
int ldap_ufn_search_s( LDAP *ld, char *ufn, char **attrs, int attrsonly,
	LDAPMessage **res );

/*
 * in unbind.c
 */
int ldap_unbind_s( LDAP *ld );

#ifdef KERBEROS
/*
 * in kerberos.c
 */
char *get_kerberosv4_credentials( LDAP *ld, char *who, char *passwd,
	char *service, int *len );
#endif /* KERBEROS */


/*
 * in getfilter.c
 */
LDAPFiltDesc *ldap_init_getfilter( char *fname );
void ldap_getfilter_free( LDAPFiltDesc *lfdp );
LDAPFiltInfo *ldap_getfirstfilter( LDAPFiltDesc *lfdp, char *tagpat,
	char *value );
LDAPFiltInfo *ldap_getnextfilter( LDAPFiltDesc *lfdp );

/*
 * in friendly.c
 */
char *ldap_friendly_name( char *filename, char *uname, FriendlyMap **map );


#ifdef WINSOCK
/*
 * in msdos/winsock/wsa.c
 */
void ldap_memfree( void *p );
#endif /* WINSOCK */
