/*
 * Copyright (c) 1990 Regents of the University of Michigan.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and that due credit is given
 * to the University of Michigan at Ann Arbor. The name of the University
 * may not be used to endorse or promote products derived from this
 * software without specific prior written permission. This software
 * is provided ``as is'' without express or implied warranty.
 */

#ifndef _LBER_H
#define _LBER_H

#ifdef __cplusplus
extern "C" {
#endif

/* BER classes and mask */
#define LBER_CLASS_UNIVERSAL	0x00
#define LBER_CLASS_APPLICATION	0x40
#define LBER_CLASS_CONTEXT	0x80
#define LBER_CLASS_PRIVATE	0xc0
#define LBER_CLASS_MASK		0xc0

/* BER encoding type and mask */
#define LBER_PRIMITIVE		0x20
#define LBER_CONSTRUCTED	0x00
#define LBER_ENCODING_MASK	0x20

/* general BER types we know about */
#define LBER_DEFAULT		0x7f	/* should work for any char type */
#define LBER_BOOLEAN		0x01
#define LBER_INTEGER		0x02
#define LBER_BITSTRING		0x03
#define LBER_OCTETSTRING	0x04
#define LBER_NULL		0x05
#define LBER_ENUMERATED		0x0a
#define LBER_SEQUENCE		0x30	/* constructed */
#define LBER_SET		0x31	/* constructed */
#define OLD_LBER_SEQUENCE	0x10	/* w/o constructed bit - broken */
#define OLD_LBER_SET		0x11	/* w/o constructed bit - broken */

typedef struct berelement {
	char		*ber_buf;
	char		*ber_ptr;
	char		*ber_end;
	struct seqorset	*ber_sos;
	int		ber_tag;
	int		ber_usertag;
} BerElement;
#define NULLBER	((BerElement *) 0)

typedef struct sockbuf {
#ifndef MACOS
	int		sb_sd;
#else /* MACOS */
	void		*sb_sd;
#endif /* MACOS */
	BerElement	sb_ber;
} Sockbuf;
#define READBUFSIZ	8192

typedef struct seqorset {
	BerElement	*sos_ber;
	unsigned long	sos_clen;
	unsigned char	sos_tag;
	char		*sos_first;
	char		*sos_ptr;
	struct seqorset	*sos_next;
} Seqorset;
#define NULLSEQORSET	((Seqorset *) 0)

/* structure for returning a sequence of octet strings + length */
struct berval {
	unsigned long	bv_len;
	char		*bv_val;
};

#ifndef NEEDPROTOS
extern BerElement *ber_alloc();
extern BerElement *ber_dup();
extern int lber_debug;
#else /* NEEDPROTOS */
#include "proto-lber.h"
#endif /* NEEDPROTOS */

#ifdef __cplusplus
}
#endif
#endif /* _LBER_H */
