/*:::::::::::::::::::::MODULO:::::::::(legiblec.c)::::::::::::::::::::::::::*/
#define LEGIBLECMODULE
#include "legiblec.h" 

/*...... Para el TRY-RECOVER............... */
#include <setjmp.h>
jmp_buf *active_jump=NULL;

/*..... Para los warnings ................. */
#define MAXWARNINGS 20
LOCAL int numWarn=0;
LOCAL char *listaWarnings[MAXWARNINGS];

/*.......Asignacion dinamica de memoria (NEW).........*/

#include <stdlib.h>

/*---------------------------------------------------------*/
EXPORT_FUNCTION char * NEWSTR(char const *s) 
{
char *p;
p=(char *)malloc(strlen(s)+1);
IF p==NULL THEN EXCEPTION(excpNOMEMSTR); return NULL; 
ELSE strcpy(p,s); return p; ENDIF;
}

/*---------------------------------------------------------*/
EXPORT_FUNCTION void * newitem(int bytes)
{
void *p;
p=(void *)malloc(bytes);
IF p==NULL THEN EXCEPTION(excpNOMEM); return NULL; ELSE return p; ENDIF;
}

/*---------------------------------------------------------*/
/* Apunta un warning en la lista de warnings (maximo       */
/* MAXWARNINGS warnings)                                   */
EXPORT_PROCEDURE WARNING(char const *warningMess)
{
IF numWarn<MAXWARNINGS THEN 
  listaWarnings[numWarn]=NEWSTR(warningMess);   numWarn++;
  ENDIF
}

/*---------------------------------------------------------*/
/* Llama a la procedure indicada sucesivamente para        */
/* mostrar los warnings, hasta el numero (nivel) indicado. */
/* Luego libera la lista de warnings.                      */
EXPORT_PROCEDURE ShowWarnings( 
                     EXTERNAL_PROCEDURE MuestraWarning(char const *warningMess),
                     int level
                     )
{
int n;
FOR n=0; n<numWarn; n++ DO 
  IF n<level  THEN MuestraWarning( listaWarnings[n] );  ENDIF
  RELEASE( listaWarnings[n] ); n++;
  ENDFOR
numWarn=0;  
}


/*...............Utilidades Conjunto...............*/

/*---------------------------------------------------------*/
/* Agnade un elemento a un conjunto                        */
/* (tantos elementos como bit en el tipo SET)              */
EXPORT_PROCEDURE AddToSet(SET VAR conjunto, int elemento)
{
IF elemento >= sizeof(SET)*8 THEN EXCEPTION(excpOUTOFSET); 
ELSE
  *conjunto= *conjunto | 1<<elemento;
  ENDIF;

}

/*---------------------------------------------------------*/
/* Comprueba si un elemento esta en un conjunto            */
EXPORT_FUNCTION int IsInSet(SET conjunto, int elemento)
{
return ( conjunto & 1<<elemento ) != 0 ;
}

/*...............Utilidades String...............*/

/*---------------------------------------------------------*/
/* Copia un string, ASEGURANDOSE de no copiar mas de lo que*/
/* cabe en el destino. max es el tamagno de sd             */
EXPORT_PROCEDURE strMcpy(char *sd,char *so, int max)
{
int l,maxl;
l=0; maxl=max-1;
WHILE so[l]!=StrEnd AND l<maxl  DO  sd[l]=so[l]; ++l;  ENDWHILE;  
sd[l]=StrEnd;
}

/*---------------------------------------------------------*/
/* Concatena un string, ASEGURANDOSE de no copiar mas de lo*/
/* que cabe en el destino. max es el tamagno de sd         */
EXPORT_PROCEDURE strMcat(char *sd, char *so, int max)
{
int ld,l,maxl;
ld=strlen(sd); if (ld>=max-1) return;
l=0; maxl=max-1;
WHILE so[l]!='\0'  AND ld<maxl DO sd[ld]=so[l]; ++ld; ++l; ENDWHILE; 
sd[ld]=StrEnd;
}

/*----------------------------------------------------------*/
/* Devuelve en val el string correspondiente a un valor     */
/* discreto. Devuelve TRUE si bien, FALSE si no existe ese  */
/* valor en la tabla. La tabla es un string con los valores */
/* separados por ",". Maxlon dice la maxima capacidad de val*/
EXPORT_FUNCTION boolean value2st(char *val,int maxlon,int d, char *tabla)
{
int j,NumVal,i,lontab;  char c;

j=0; NumVal=0;  val[0]=StrEnd;   lontab=strlen(tabla);
FOR i=0; i<=lontab; ++i DO
  c=tabla[i];
  IF c==',' OR c==StrEnd THEN 
    IF NumVal==d THEN  return TRUE; ELSE NumVal++; ENDIF;
  ELSE
    IF NumVal==d THEN
      val[j]=c; ++j;  val[j]=StrEnd;
      IF j>=(maxlon-1) THEN return TRUE; ENDIF;
      ENDIF;
    ENDIF;
  ENDFOR;

IF j==0 THEN 
  IF maxlon>=2 THEN strcpy(val,"?"); ENDIF;
  return FALSE; 
  ENDIF;
return TRUE;
}


