/*
# Gopher-nnrp Gateway
#
#  DEC 1995 C VERSION !!! HMR-CIUV (c)
#
# 23-Aug-1994 version 2.4 Chad Adams c-adams@bgu.edu
# more fixes for Solaris 2.3
#
# 12-Apr-1994 version 2.3 Chad Adams c-adams@bgu.edu
# support INN running on solaris and 'mode reader' nntp command
#
# 08-Jun-1993 version 2.2 Chad Adams (c-adams@bgu.edu)
# remove hardcoded paths and make -G with no param work
#
# 28-May-1993 version 2.1 Chad Adams (c-adams@bgu.edu)
# build in access control for clari groups.  Make errors returned the same
#   format as server errors so our version of gopher will put them in pop
#   up box.
#
# 28-May-1993 version 2.0 Chad Adams (c-adams@bgu.edu)
# major rewrite by: Chad Adams
# add newgroups database.
# add multi level newsgroup menus.  [each .part. of newsgroup automaticly
#   gets it's own menu instead of putting all (like all of comp) in one
#   menu.  {now menus like comp.sys, comp.lang, comp.sources, ect..}]
# convert to use xhdr instead of tin's xindex.  If not used with INN using
#   overview files to speed up xhdr it may be slow.
#
# Gopher-NNTP Gateway version 1.0
# Author: Daniel Schales (dan@engr.latech.edu)
# Major rewrite, socket support: Doug Schales (d1s8027@sc.tamu.edu)
#
# Configuration: All variables can be defined in the config file (always
# searched). Only the name of it is needed here. 
#
# Config file example (warn to begin lines with exactly these variable
# names).
# 
# 
# GopherHost     gopher.uv.es
# GopherPort     70
# nntpHost       news.uv.es
# nntpPort       nntp
# LogFileName    *              # path to logfile. "*" if no log desired
# gonnrp         /bin/gonnrp    # path to shell script that spawns 
#                               #   this program 
# newsdbm        newsgroups     # path to newsgroups dbm files 
# KilledGroups   killedgroups   # path to file with killedgroups
# CacheFile      cachefile      # path to cachefile. "*" if no cache desired
*/
                              
#include <signal.h>
#include <stdio.h>
#include <strings.h>
#include <time.h>
#include <stdlib.h>

#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

#include <ndbm.h>
#include <fcntl.h>

#include "legiblec.h"

/*
# The following definitions are only default values. 
#
# Set the following variables for your setup. the 2 port variables
# are set to the standard, be sure to set gopherhost and nntphost to
# your respective hosts.
*/

LOCAL char configFile[]="cgonnrp.conf";   /* Config file name */

/* ... Nex Values are modifiables via config file! ... */
LOCAL char gopherHost[255]="video.uv.es";
LOCAL int  gopherPort=70;
LOCAL char nntpHost[255]="news.uv.es";
LOCAL char nntpprt[255]="nntp";
LOCAL char logFileName[255]="/tmp/nntplog_c";

LOCAL char gonnrp[255] = "/bin/gonnrp";  /*  path to shell script that spawns 
                                          this program */
LOCAL char newsdbm[255] = "/home/gopher/datos/bin/newsgroups"; 
                                      /* where the newsgroups dbm files are */
LOCAL char killedGroups[255]="killedgroups";
LOCAL char cachefile[255]="groupcache";  /* Name of cache for groups. "*" if
                                            no cache */

/* ... */

#define ELINPUT 0
#define ELOUTPUT 1
#define ELERROR 2

RECORD groupdesc {
      int code,count,low,high;
      } groupdesc;
      
LOCAL groupdesc gDescrip;

RECORD itemIndex {
  char *s;
  int *lista,lonLista, first;
  ITSELF itemIndex *next;
  } itemIndex;
  
RECORD stringList {
  int numel,maxel;
  char **l;
  } stringList;
  
#define MAXARTTHREAD 20 /* Max # of articles in one thread to 
                           switch to minmax thread representation */
#define ISMINMAX 999    /* Must be greater than MAXARTTHREAD */

#define MAXTHREAD 1000  /* Max # of articles in one thread. */
#define MAXGROUPS 20000 /* Max # of groups for -C */
      
#define StrBegins(s,beginstr) (strncmp(s,beginstr,strlen(beginstr))==0)
#define StrEmpty(s) (s[0]==StrEnd)

#define NIL NULL

/*-------------------------------------------------------------------------*/
LOCAL  int argIndex=1, Argc;
LOCAL  char **Argv;

FUNCTION char *ShiftArgs()
{
  char *p;
  static char *nullstr="";
  IF argIndex>=Argc THEN p=nullstr; 
  ELSE
    /* printf("c=%d i=%d\n",Argc,argIndex);   */
    p=Argv[argIndex]; ++argIndex; 
    ENDIF
  return p;
}

/*-------------------------------------------------------------------------*/
FUNCTION stringList *NEWLIST(int maxelements)
{
  stringList *sl;
  sl=newitem( sizeof(stringList) );
  sl->numel=0;   sl->maxel=maxelements;
  sl->l=newitem(maxelements*sizeof(char *));
  return sl;
}

PROCEDURE ADDTOLIST( stringList *sl, char *s)
{
  IF sl->numel >= sl->maxel THEN EXCEPTION(1005); ENDIF
  sl->l[sl->numel]=NEWSTR(s); sl->numel++;
}

PROCEDURE RELEASELIST( stringList *sl)
{
  int i;
  FOR i=0;i<sl->numel;++i DO RELEASE(sl->l[i]); ENDFOR;
  RELEASE(sl);
}

/*-------------------------------------------------------------------------
 * Copies a string converting it to lowercase.                             
 * dest & orig can be the same string
 */
PROCEDURE LowCase( char *dest, char *orig, int max)
{
int i,c,num; 
num=strlen(orig); if (num>=max) num=max;
FOR i=0; i<num; ++i DO
  c=orig[i]; 
  IF (c>='A') AND (c<='Z') THEN c=c+32; ENDIF   
  dest[i]=c;
  ENDFOR
dest[i]=StrEnd;
}

/*-------------------------------------------------------------------------*/
PROCEDURE Chop(char *s)
{ 
  int lon;
  lon=strlen(s);
  IF lon >0 THEN s[lon-1]=StrEnd; ENDIF;
}

/*-------------------------------------------------------------------------*/
PROCEDURE ServerError(char *s)
{
  printf("0Server error: %s\t\terror.host\t1\r\n",s);
  printf(  ".\r\n" );
  fflush(stdout);
  exit (0);
}

/*-------------------------------------------------------------------------*/
PROCEDURE LogMessage(char *info)
{
  FILE *log;
  char dateLin[50];
  time_t tloc;
  struct tm tim;
  char mess[255];
  int i;

  time(&tloc);
  strftime(dateLin,50,"%X",localtime(&tloc));

  FOR i=0; i<Argc; ++i DO 
    strMcat(mess,Argv[i],255); strMcat(mess," ",255); 
    ENDFOR;

  log=fopen(logFileName,"a");
  IF log != NULL THEN
    fprintf(log, "%s: %s %s\n",dateLin,info,mess);
    fclose(log);
    ENDIF;

}

/*-------------------------------------------------------------------------*/

PROCEDURE stuck()
{
  LogMessage("stuck on");
  exit(0) ;
}


/*-------------------------------------------------------------------------
 *return error when nntp command fails
 */
FUNCTION checkcode (char *coderror, int goodcode)
{ 
  int code; char *auxs;
  code=atoi(coderror);  
  IF code != goodcode THEN
    auxs=NEWSTR(coderror); 
    Chop(auxs); Chop(auxs);
    printf( "0nnrp error: %s\t\terror.host\t1\r\n",auxs );
    printf(  ".\r\n" );
    RELEASE(auxs);
    exit(0);
    ENDIF
}


/*-------------------------------------------------------------------------*/
#define INIT       register char *sp = instring;
#define GETC()    (*sp++)
#define PEEKC()   (*sp)
#define UNGETC(c)  (--sp)
#define RETURN(c)  return
#define ERROR(c)   ServerError("matching routine crash!")

#include <regexp.h>
  
FUNCTION match(char *expresion, char *linebuf)
{
  #define ESIZE 1024
  char expbuf[ESIZE], *instring;
  
  compile(expresion, expbuf, &expbuf[ESIZE],'\0');
  
  return step(linebuf, expbuf);

}

/*-------------------------------------------------------------------------
 */

#define FORFILE_LINES(nomfile,maxlonline)  {  \
FILE *fil_rfile; \
char line[maxlonline]; int  lonLine;\
fil_rfile=fopen( (nomfile),"r"); \
if (fil_rfile==NULL) EXCEPTION(1004); \
WHILE fgets(line,maxlonline,fil_rfile) != NULL DO \
  lonLine=strlen(line); \
  IF line[lonLine-1]=='\n' THEN line[lonLine-1]='\0'; ENDIF { 
  
#define ENDFORFILE   } ENDWHILE; fclose(fil_rfile); } 

 
/*-------------------------------------------------------------------------*/
PROCEDURE SubStr(char *destino, int maxlon, char *origen, int offset, int lon)
{
int l,i; char *orig; register c;
orig=origen+offset; i=0;
IF lon<=maxlon THEN l=lon; ELSE l=maxlon; ENDIF;
REPEAT
  c=orig[i];  destino[i]=c; i++;
UNTIL (c==StrEnd OR i==l);
}

/*-------------------------------------------------------------------------*/
#define TAMBUF 1500
LOCAL char *pBuf[10],*pfinBuf[10],*linBuff[10];

/*.........................................................................*/
PROCEDURE SinitGets(int fd)
{
  IF fd>10 THEN
    ServerError("Too many file descriptors open");
    ENDIF
    
  linBuff[fd]=newitem(TAMBUF);
  pBuf[fd]=pfinBuf[fd];
}

/*.........................................................................*/
PROCEDURE ScloseGets(int fd)
{
  RELEASE(linBuff[fd]);
}

/*.........................................................................
 * Reads a line s (ended by \r\n, max length=maxlon) from file descriptor fd
 * The read is buffered in a TAMBUF buffer.
 * Returns <0 if error. Discards CR & NL.
 */
FUNCTION int Sgets(char *s, int maxlon, int fd)
{

  int cnt;
  char *ps,*pfins,sigo;
  char *pbuf,*pfinbuf,*linbuff;

  pbuf=pBuf[fd]; pfinbuf=pfinBuf[fd]; linbuff=linBuff[fd];
  ps=s;  pfins=ps+maxlon-1;

  sigo=TRUE;

  REPEAT
    IF pbuf>=pfinbuf THEN
      cnt=read(fd,linbuff,TAMBUF-1);
      IF cnt<0 THEN return cnt; ENDIF
      pbuf=linbuff; pfinbuf=pbuf+cnt;
    ELSE 
      *ps=*pbuf; 
      IF *pbuf=='\n' OR ps==pfins THEN sigo=FALSE; ENDIF
      ++ps; ++pbuf;  
    ENDIF
  UNTIL (NOT sigo);
    
  IF *(ps-1)=='\n' THEN
    *(ps-2)='\0'; /* Suprime CR y NL */  
    ENDIF
  
  pBuf[fd]=pbuf; pfinBuf[fd]=pfinbuf; 

  return ps-s-2;

}

/*-------------------------------------------------------------------------
 * Writes a line to file descritor fs, adding \r\n.
 */
PROCEDURE Sputs(char *linea, int fd)
{
write(fd,linea,strlen(linea)); write(fd,"\r\n",2);
}

/*-------------------------------------------------------------------------*/
char tokenAux[255];

PROCEDURE StrToken(char *destino, int maxlon, char *linea, char *separ)
{
char *p;

strMcpy(tokenAux,linea,255);
p=strtok(tokenAux,separ);
IF p!= NULL THEN strMcpy(destino,p,255);
ELSE StrErase(destino); ENDIF
}

/*..........................................................................*/
PROCEDURE StrNextToken(char *destino, int maxlon, char *separ)
{
char *p;
p=strtok(NULL,separ);
IF p!= NULL THEN strMcpy(destino,p,255);
ELSE StrErase(destino); ENDIF
}

/*-------------------------------------------------------------------------*/
FUNCTION char *Obten(DBM *database, char *key)
{
static char dato[255];
datum d,od;
d.dptr=key; d.dsize=strlen(key);
od=dbm_fetch(database,d);
IF od.dsize>=255 THEN od.dsize=255-1; ENDIF
IF od.dptr==NULL THEN od.dsize=0; ENDIF
strncpy(dato,od.dptr,od.dsize);  dato[od.dsize]=StrEnd;
return dato;
}

/*-------------------------------------------------------------------------*/
PROCEDURE Agnade(DBM *database, char *key, char *value)
{
static char dato[255];
datum dkey,dvalue;
int status;
dkey.dptr=key; dkey.dsize=strlen(key);
dvalue.dptr=value; dvalue.dsize=strlen(value);
status=dbm_store(database,dkey,dvalue,DBM_INSERT);
IF status<0 THEN EXCEPTION(1006); ENDIF
}

/*-------------------------------------------------------------------------
 */
 
FUNCTION int ComparFunct(const char **one, const char **two)
{
  return strcmp( *one, *two);
} 

PROCEDURE Sort(stringList *lista)
{
  qsort( lista->l,lista->numel,sizeof(char *),(void *)ComparFunct );
}
 
/*-------------------------------------------------------------------------
 * -C    Builds newsgroup cache. Gets group list form server, sorts it,
 *       and write it to cachefile.
 */
PROCEDURE Do_C(int fnntp)
{
  char nlin[255], headLine[255];
  stringList *lista;
  int i;
  FILE *cache;
 
  IF StrEqual(cachefile,"*") THEN
    ServerError("No group cachefile defined");
    ENDIF;
    
  lista=NEWLIST(MAXGROUPS);
  
  Sputs( "LIST", fnntp);
  Sgets(headLine, 255,fnntp);

  /* Gets group list */
  Sgets(nlin, 255,fnntp);
  WHILE NOT StrEqual(nlin,".") DO
    TRY
      ADDTOLIST(lista,nlin); 
    RECOVER
      ServerError("Too many groups!");
      ENDRECOVER
    Sgets(nlin, 255,fnntp);
    ENDWHILE

  Sort(lista); 

  /* Save it to cachefile */
  cache=fopen(cachefile,"w");
  IF cache==NULL THEN ServerError("Can't create group cachefile");
  ELSE
    fprintf(cache,"%s\r\n", headLine); 
    FOR i=0; i<lista->numel; ++i DO  
      fprintf(cache,"%s\n", lista->l[i]); 
      ENDFOR;
    fprintf(cache,".\r\n"); 
    fclose(cache);
    printf("DONE.\r\n");
    ENDIF
  
  RELEASELIST(lista);    
}

/*-------------------------------------------------------------------------
 * -B dfile ...  Builds newsgroup description database from dfiles
 */
PROCEDURE Do_B(void)
{
  DBM *newsgroups;
  char *nomDFile,group[255],gDescription[255];
  
  newsgroups=dbm_open( newsdbm, O_CREAT | O_RDWR  ,0644);

  IF newsgroups==NULL THEN 
    ServerError("Can't create newsgroups database");
    ENDIF
  
  nomDFile=ShiftArgs();
  
  IF StrEmpty(nomDFile) THEN ServerError("No Description file(s)!"); ENDIF;

  WHILE NOT StrEmpty(nomDFile) DO
    printf("ADDING %s\n", nomDFile);  
    FORFILE_LINES(nomDFile,255);
      StrToken(group,255,line,"\t"); 
      StrNextToken(gDescription,255,"\t");
      IF NOT ( StrEmpty(gDescription)  OR 
               StrEqual(gDescription,"x") OR
               StrEqual(gDescription,"y") OR
               StrEqual(gDescription,"?") ) THEN
         /* printf("%s -- %s\n", group, gDescription);  */
        Agnade(newsgroups,group,gDescription);
        ENDIF
      ENDFORFILE
    nomDFile=ShiftArgs();
    ENDWHILE
  
  printf("DONE.\n");
}

/*-------------------------------------------------------------------------
 * -g pattern      retrieve all matching groups (as shipped gonnrp only
 *               matches with the beginning of the group name)
 *               Does not split up groups on '.'s like -G does.
 *
 * WARN: THIS DOESN'T SORT OUTPUT !!
*/
PROCEDURE Do_g(char *item, int fnntp)
{
  DBM *newsgroups;
  char nlin[255], group[255];
  
  newsgroups=dbm_open( newsdbm, O_RDONLY  ,0444);
  IF newsgroups==NULL THEN 
    ServerError("Can't open newsgroups database");
    ENDIF

  Sputs( "LIST", fnntp);
  
  WHILE NOT StrEqual(nlin,".") DO
    Sgets(nlin, 255,fnntp);
    IF StrBegins(nlin,item) THEN
      StrToken(group,255,nlin," "); 
      printf("1%s - %s\texec:-h %s %s\t%s\t%d\r\n",
             group,Obten(newsgroups,group),group,gonnrp,gopherHost,gopherPort);
      ENDIF
    ENDWHILE

  printf(".\r\n");
}

/*-------------------------------------------------------------------------
 * -G pattern              Same as -g, except prepare to thread groups
 *                         and split groups on '.'s into sub-menus
 *
 * WARN: THIS DOESN'T SORT OUTPUT !!
*/
PROCEDURE Do_G(char *item, int fnntp)
{
  DBM *newsgroups;
  char nlin[255], group[255],grpart[255];
  
  int itemlen;
  char dot[20],grp[255],oldgrp[255];
  boolean alreadyget;
  
  newsgroups=dbm_open( newsdbm, O_RDONLY  ,0444);
  IF newsgroups==NULL THEN 
    ServerError("Can't open newsgroups database");
    ENDIF

  Sputs( "LIST", fnntp);
  
  Sgets(nlin, 255,fnntp);

  IF StrEmpty(item) THEN
    itemlen=0;
    StrErase(dot);
  ELSE
    itemlen=strlen(item)+1; /* to skip "." */
    strcpy(dot,".");
    ENDIF

  StrErase(oldgrp);  alreadyget=FALSE;
  
  WHILE NOT StrEqual(nlin,".") DO
    IF NOT alreadyget THEN
      Sgets(nlin, 255,fnntp); 
      /* printf("0-%s-%d---\n",nlin,alreadyget);      */
      ENDIF
    alreadyget=FALSE;  
    
    IF StrEqual(nlin,".") THEN break; ENDIF;

    IF StrBegins(nlin,item) THEN /* it's one of them */
      StrToken(group,255,nlin," "); 
      IF StrEqual(group,item) THEN /* it's the one */
        strMcpy(grp,group,255);
        printf("1%s\texec:-T %s:%s\t%s\t%d\r\n",
             Obten(newsgroups,group),group,gonnrp,gopherHost,gopherPort);
      ELSE
        char allName[255]; 

        /* discard local.anuncios if asked for local.a !! */
        IF itemlen!=0 AND group[itemlen-1]!='.' THEN continue; ENDIF
        
        SubStr(grp,255,group,itemlen,40);  /* extracts grp: item.grp */
        
        IF strchr(grp,'.')!=NULL THEN      /* grp has sublevels: item.grp1.grp2 */
          StrToken(grpart,255,grp,".");    /* extracts group part (grp1) */
          IF StrEqual(grpart,oldgrp) THEN continue; ENDIF  /* already printed */
          strcpy(oldgrp,grpart);   
          
          /* prints thread  "all" description */
          sprintf(allName,"%s%s%s.all",item,dot,grpart);   
          printf("1%s - %s\texec:-G %s%s%s:%s\t%s\t%d\r\n",
               grpart,Obten(newsgroups,allName),item,dot,grpart,
               gonnrp,gopherHost,gopherPort);
        ELSE                              /* grp doesn't have sublevels */
          char nextGroup[255],allName[255];
          
          /* Gets next group */
          Sgets(nlin, 255,fnntp); alreadyget=TRUE;
          StrToken(nextGroup,255,nlin," ");

          IF StrBegins(nextGroup,group) THEN /* but it is a thread ! */
            /* prints thread  "all" description */
            sprintf(allName,"%s%s%s.all",item,dot,grp);  
            printf("1%s - %s\texec:-G %s:%s\t%s\t%d\r\n",
                   grp,Obten(newsgroups,allName),group,
                   gonnrp,gopherHost,gopherPort);
            strcpy(oldgrp,grp);   
            
          ELSE                               /* not a thread */
            printf("1%s - %s\texec:-T %s:%s\t%s\t%d\r\n",
                 grp,Obten(newsgroups,group),group,
                 gonnrp,gopherHost,gopherPort);
            ENDIF
          ENDIF
        ENDIF
        
      ENDIF
    ENDWHILE

  printf(".\r\n");
}

/*-------------------------------------------------------------------------*/
FUNCTION groupdesc GroupData(char *nomGroup, int fnntp)
{ 
  char nlin[255],auxs[255];
  groupdesc gd;
        
  sprintf(nlin,"group %s",nomGroup);
  Sputs(nlin, fnntp );

  Sgets(nlin, 255,fnntp);
  
  sscanf(nlin, "%d%d%d%d",&gd.code,&gd.count,&gd.low,&gd.high);
  /* printf("->%d% d% d% d\n",gd.code,gd.count,gd.low,gd.high); */
  
  checkcode(nlin,211);

  return gd;
}

/*-------------------------------------------------------------------------*/
PROCEDURE Xhdr( char *hdrtype, int low, int high, int fnntp)
{
  char nlin[255];

  sprintf(nlin,"xhdr %s %d-%d",hdrtype, low, high);
  Sputs(nlin, fnntp );
  Sgets(nlin, 255,fnntp);
  checkcode(nlin,221);

}

/*-------------------------------------------------------------------------
 * -h group        retrieve subject headers from specified group
 * 
 * -b group        same as -h, but sets up next level to only display
 *                 the body of the article (no headers) 
 *                 
 * 
 * -s group keyword        same a -h but display only subject lines
 *                         which contain keyword. Currently limited to
 *                         one word, should be easily fixed for more.
 *                         To use this from gopher, you will have to call
 *                         a shell script to run gonnrp rather than exec'ing
 *                         gonnrp directly. I am still working on the 
 *                         search stuff, may change it later...
 *                         (untested in gonnrp)
 * 
*/
PROCEDURE Do_hbs(char *option, char *item, char *lookup, int fnntp)
{
  groupdesc gd;
  
  char nlin[255], num[255],description[255];
  
  gd=GroupData(item, fnntp);
  
  IF gd.count != 0 THEN
    Xhdr("subject", gd.low, gd.high, fnntp);
    
    Sgets(nlin, 255,fnntp);
    
    WHILE NOT StrEqual(nlin,".") DO
      StrToken(num,255,nlin," ");
      StrNextToken(description,255,"\n");

      IF StrEqual(option,"-h") THEN
        printf("0%s\texec:-a %s %s:%s\t%s\t%d\r\n",
               description,item,num,gonnrp,gopherHost,gopherPort);
      ELSIF StrEqual(option,"-b") THEN
        printf("0%s\texec:-a %s %s body:%s\t%s\t%d\r\n",
               description,item,num,gonnrp,gopherHost,gopherPort);
      ELSIF StrEqual(option,"-s") THEN
        char loDescription[255], loLookup[255];
        LowCase(loDescription,description,255);
        LowCase(loLookup,lookup,255);
        IF match(loLookup, loDescription) THEN
          printf("0%s\texec:-a %s %s:%s\t%s\t%d\r\n",
                 description,item,num,gonnrp,gopherHost,gopherPort);
          ENDIF
        ENDIF
         
      Sgets(nlin, 255,fnntp);
      ENDWHILE
    ENDIF

  printf(".\r\n");
}

/*-------------------------------------------------------------------------
 * -a group # [body]       Internal option to retrieve article # from
 *                         group. If body is specified then only the
 *                         body of the article is displayed (no headers).
 *                         The -a option should never be used in a .link
 *                         file unless you never get rid of news articles. 
 * 
*/
PROCEDURE Do_a(char *item, char *number, char *body, int fnntp)
{
  groupdesc gd;
  char nlin[255];
  
  gd=GroupData(item, fnntp);
  
  IF StrEqual(body,"body") THEN
    sprintf(nlin,"BODY %s",number);
    Sputs(nlin, fnntp);
    Sgets(nlin, 255,fnntp);
    checkcode(nlin,222);
  ELSE
    sprintf(nlin,"ARTICLE %s",number);
    Sputs(nlin, fnntp);
    Sgets(nlin, 255,fnntp);
    checkcode(nlin,220);
    ENDIF

  Sgets(nlin, 255,fnntp);
  WHILE NOT StrEqual(nlin,".") DO
    printf("%s\r\n",nlin);
    Sgets(nlin, 255,fnntp);
    ENDWHILE

  /* printf(".\r\n"); Don't needed! Baffles some clients! */
}

/*-------------------------------------------------------------------------
 * -l group [body]            Show last article from a group. 
 */
PROCEDURE Do_l(char *item, char *body, int fnntp)
{
  groupdesc gd;
  char nlin[255];
  
  gd=GroupData(item, fnntp);
  
  IF gd.count!=0 THEN

    IF StrEqual(body,"body") THEN
      sprintf(nlin,"BODY %d",gd.high);
      Sputs(nlin, fnntp);
      Sgets(nlin, 255,fnntp);
      checkcode(nlin,222);
    ELSE
      sprintf(nlin,"ARTICLE %d",gd.high);
      Sputs(nlin, fnntp);
      Sgets(nlin, 255,fnntp);
      checkcode(nlin,220);
      ENDIF

    Sgets(nlin, 255,fnntp);
    WHILE NOT StrEqual(nlin,".") DO
      printf("%s\r\n",nlin);
      Sgets(nlin, 255,fnntp);
      ENDWHILE
    ENDIF

  printf(".\r\n");
}

/*-------------------------------------------------------------------------
 * Finite-State machine to skip (re[: ])* at beginning of string nlin.
 * Returns pointer in nlin.
 */
FUNCTION char *SkipRe(char *nlin)
{
  int i,beginSbj,state;
  boolean found;
  char c;

  i=0; found=FALSE; state=0;  beginSbj=0;
  REPEAT
    
    c=nlin[i];
    IF state==0 THEN               /* Initial */
      IF c=='r' OR c=='R' THEN     
        state=1; 
      ELSIF  c==' ' OR c==':' THEN /* Skips " " & ":" */ 
        ;
      ELSE
        found=TRUE; beginSbj=i;     /* OK */
        ENDIF
    ELSIF state==1 THEN             /* Received "r" */
      IF c=='e' OR c=='E' THEN     
        state=2; 
      ELSE 
        found=TRUE; beginSbj= i-1;  /* OK, but don't forget "r" */
        ENDIF
    ELSE /* state==2 */             /* Received "re" */
      IF c==' ' OR c==':' THEN
        state=0;                    /* Received "re:" or "re " */
      ELSE
        found=TRUE; beginSbj= i-2;  /* OK, but don't forget "re" */
        ENDIF
      ENDIF
    i++;
  UNTIL (c==StrEnd OR found);

  /* printf("skipre %s --- %s\n",nlin,&(nlin[beginSbj])); */
  return &(nlin[beginSbj]);
}

/*-------------------------------------------------------------------------
 * Creates a associative linked list of articles. The article numArt is
 * added to the item that matches subj, or it this doesn't exists a new
 * item is created.
 */
PROCEDURE AddArticle(int numArt, char *subj, itemIndex **sbjIndex)
{
  itemIndex *item, **nilPlace, *found;
  boolean exists;
  
  /* Search if "subj" exists in the list */
  item=*sbjIndex; nilPlace=sbjIndex; found=NULL; 
  WHILE item != NIL DO
    IF StrEqual(subj,item->s) THEN found=item; ENDIF;
    nilPlace=&(item->next);    
    item=item->next;
    ENDWHILE
  
  /* Add article */
  IF found==NULL THEN /* Add new article or Thread */
    /* printf("NEW ART--%s\n",subj);  */
    item=newitem(sizeof( itemIndex) );
    item->s=NEWSTR(subj);
    item->first=numArt;
    item->lista=NULL; item->lonLista=0;
    item->next=NIL;
    *nilPlace =item; /* Adds to the -END- of the linked list */
    
  ELSE /* Add article to this thread */
    /* printf("ADD THREAD %s\n", subj);  */
    IF found->lonLista==0 THEN  /* Create article list */
      found->lista=newitem( MAXARTTHREAD* sizeof(int));
      ENDIF
    /* Add to the list */
    IF found->lonLista< MAXARTTHREAD THEN /* OK. Space enough */
      found->lista[found->lonLista]=numArt; found->lonLista++; 
    ELSE /* NO. Only Min/Max is remembered */
      found->lonLista=ISMINMAX;
      found->lista[0]=numArt;   /* this suposses that articles are 
                                  always added in article order */
      ENDIF
    ENDIF
}


/*-------------------------------------------------------------------------
 * Build subject threads
 */
 
FUNCTION itemIndex *buildidx(int low, int high, int fnntp)
{
  int first, art;
  char nlin[255], subj[255], anum[255];
  itemIndex *sbjIndex;
  
  Xhdr("subject", low, high, fnntp);
  
  sbjIndex=NIL;
  REPEAT
    Sgets(nlin, 255,fnntp);
    IF StrEqual(".",nlin) THEN break; ENDIF;
    
    StrToken(anum,255,nlin," "); art=atoi(anum);
    StrNextToken(subj,255,"\n");

    AddArticle( art, SkipRe(subj), &sbjIndex);  
    
  UNTIL ( FALSE );
  
  return sbjIndex;
}

/*-------------------------------------------------------------------------
 * -T group                Same as -h except thread articles.
 */
PROCEDURE Do_T(char *item, int fnntp)
{
  groupdesc gd;
  char nlin[255];
  itemIndex *sbjIndex, *thread;
  int i;
  
  gd=GroupData(item, fnntp);
  
  sbjIndex=buildidx(gd.low, gd.high, fnntp);
  
  /* Search if "subj" exists in the list */
  thread=sbjIndex; 
  WHILE thread != NIL DO
    IF thread->lonLista==0 THEN /* Single article */
      printf("0%s\texec: -a %s %d:%s\t%s\t%d\r\n",
              thread->s, item, thread->first,
              gonnrp,gopherHost,gopherPort);
    ELSE /* Thread */
      IF thread->lonLista!=ISMINMAX THEN
        printf("1%s\texec: -X %s",
                thread->s, item);
        printf(" %d",thread->first);
        FOR i=0; i<thread->lonLista; ++i DO
          printf(" %d",thread->lista[i]);
          ENDFOR
        printf(":%s\t%s\t%d\r\n",
                gonnrp,gopherHost,gopherPort);
      ELSE
        printf("1%s\texec: -X %s 0 %d %d:%s\t%s\t%d\r\n",
                thread->s, item, thread->first, thread->lista[0],
                gonnrp,gopherHost,gopherPort);
        ENDIF
      ENDIF
    thread=thread->next;
    ENDWHILE

  printf(".\r\n");
}


/*-------------------------------------------------------------------------
 * Build a article list for a thread, from articles in the range low-high.
 * The thread is defide by the first article.
 * The end of the list is defined by "0".
 */
 
FUNCTION int *buildList(int low, int high, int fnntp)
{
  boolean first;
  char nlin[255],subj[255], tSubject[255], anum[255];
  int count, *list, art;
  
  Xhdr("subject", low, high, fnntp);
  
  first=TRUE; 
  count=0; list=newitem( MAXTHREAD*sizeof(int) );
  REPEAT
    Sgets(nlin, 255,fnntp);
    IF StrEqual(".",nlin) THEN break; ENDIF;
    
    StrToken(anum,255,nlin," "); art=atoi(anum);
    StrNextToken(subj,255,"\n");

    IF first THEN strMcpy(tSubject, SkipRe(subj), 255 ); first=FALSE; ENDIF
    IF StrEqual(SkipRe(subj), tSubject) AND count<MAXTHREAD THEN
      list[count]=art; count++;
      ENDIF
    
  UNTIL ( FALSE );

  list[count]=0;
  
  return list;
}

/*-------------------------------------------------------------------------
 * Returns TRUE if art is in list.
 */
FUNCTION boolean IsInList( int art, int *list)
{
  int count, a;

  count=0; a=list[count];
  WHILE a!=0 DO 
    IF a==art THEN return TRUE; ENDIF
    count++; a=list[count]; 
    ENDWHILE
  return FALSE;
}

/*-------------------------------------------------------------------------
 * -X art# art#            Show authors from thread.  This option has two
 * -X 0 start end          forms.  The first gives a list of articles in
 *                         the thread.  If the list is too long the
 *                         second is used.  It gives the first and last
 *                         articles numbers in the thread.  Any articles in
 *                         the range that are not part of the thread are
 *                         skipped. The first article must be of the thread.
 *                     
 */
PROCEDURE Do_X(char *item, int fnntp)
{
  char nlin[255],from[255], snum[255];
  char *anum;
  int *artList, art, count ;
  int low, high;  
  
  anum=ShiftArgs();

  GroupData(item, fnntp);

  IF StrEqual(anum,"0") THEN /* rebuild list of articles from server */
    low=atoi( ShiftArgs() );  high=atoi( ShiftArgs() );
    artList=buildList(low, high, fnntp);
    
  ELSE /* builds the list of articles from args */
    artList=newitem( MAXARTTHREAD*sizeof(int) ); count=0;
    art=atoi( anum ); 
    WHILE art!=0 DO 
      artList[count]=art; ++count; art=atoi( ShiftArgs() ); 
      ENDWHILE;
    artList[count]=0;
    low=artList[0]; high=artList[count-1];    
    ENDIF

  /* printf("lo=%d, hi=%d\n", low, high);    */

  Xhdr("from", low, high, fnntp);

  count=0; art=artList[count];
  
  REPEAT
    Sgets(nlin, 255,fnntp);
    IF StrEqual(".",nlin) THEN break; ENDIF; 
    
    StrToken(snum,255,nlin," "); art=atoi(snum);
    StrNextToken(from,255,"\n");

    IF IsInList(art, artList) THEN
      printf("0%s\texec: -a %s %d:%s\t%s\t%d\r\n",
              from, item, art,
              gonnrp,gopherHost,gopherPort);
      ENDIF
  UNTIL ( FALSE );

  printf(".\r\n");
}

/*-------------------------------------------------------------------------*/
FUNCTION int OpenNNTP()
{
  int fnntp;
  struct sockaddr_in srv_addr;
  struct hostent *hp;
  
  char nlin[255];

  signal( SIGALRM, stuck );
  
  /* set an alarm 5 minutes from now, if it goes off we must be stuck */
  alarm(300);

  fnntp=socket(AF_INET,SOCK_STREAM,0);
  IF fnntp < 0 THEN
    ServerError("Can't create TCP socket");
    ENDIF
    
  hp=gethostbyname(nntpHost);
  IF hp==NULL THEN
    ServerError("Unknown NNTP host\n");
    ENDIF
    
  srv_addr.sin_port= getservbyname(nntpprt,"tcp")->s_port;
  bcopy(hp->h_addr, (char *)&srv_addr.sin_addr, hp->h_length);
  srv_addr.sin_family=AF_INET;
  IF connect(fnntp, (struct sockaddr *)&srv_addr, sizeof(srv_addr)) <0 THEN
    ServerError("Can't connect to server");
    ENDIF

  SinitGets(fnntp);
  
  Sgets(nlin,255,fnntp);
    
  Sputs("MODE READER",fnntp); 
  
  Sgets(nlin,255,fnntp);

  return fnntp;
}

/*-------------------------------------------------------------------------*/
PROCEDURE CloseNNTP(int fnntp)
{
  Sputs("QUIT",fnntp); 
  
  ScloseGets(fnntp);
  
  shutdown(fnntp, 2); 
}

/*============================================================================
 * MAIN FUNCTION
 */
EXPORT_FUNCTION int main(int argc, char **argv)
{
  char *item, *option;
  int fnntp;

TRY
  argIndex=1; Argc=argc; Argv=argv;  /* Initializes ShiftArgs */
  
  IF argc > 1 THEN 
    option=ShiftArgs();
  ELSE
    printf("Syntax:\n");
    printf("  gonnrp [-f copyright_file] [option] item lookup \n");
    printf("Options can be:\n");
    printf("  -f copyright_file  Writes 1st line of copyright file\n");
    printf("  -g [subgroup]      Gets all groups or all subgroups of a group\n");
    printf("  -G [subgroup]      Same, but threaded.\n");
    printf("  -h group           retrieve subject headers from specified group\n");
    printf("  -T group           Same, but threaded.\n");
    printf("  -b group           same, but next level doesn't display headers\n");
    printf("  -s group keyword   same as -h, but only if subject contains keyword\n");
    printf("  -a group # [body]  retrieves article # from group [only body, no header]\n");
    printf("  -l group [body]    retrieves last art. from group [only body, no header]\n");
    printf("  -X group art ...   Show article authors.\n");
    printf("  -X group 0 first last  \n");
    printf("                     Show article authors for articles in range first-last,\n");
    printf("                     but only if they are of the same thread as the first \n");
    printf("                     one.\n");
    printf("  -C                 Builds group cache \n");
    printf("  -B dfile ...       Builds newsgroups database\n");
    ServerError("no option for GONNRP");
    ENDIF

  IF StrEqual( "-t", option) THEN option= "-h"; ENDIF

  TRY /* Reading config file */
    FORFILE_LINES(configFile,255)
      char nom[255],value[255];
      StrErase(nom); StrErase(value);  
      sscanf(line,"%s%s",nom,value);
      IF StrEqual(nom,"GopherHost") THEN strMcpy(gopherHost,value,255); ENDIF;
      IF StrEqual(nom,"GopherPort") THEN gopherPort=atoi(value); ENDIF;
      IF StrEqual(nom,"nntpHost")   THEN strMcpy(nntpHost,value,255); ENDIF;
      IF StrEqual(nom,"nntpPort")   THEN strMcpy(nntpprt,value,255); ENDIF;
      IF StrEqual(nom,"LogFileName") THEN strMcpy(logFileName,value,255); ENDIF;
      IF StrEqual(nom,"gonnrp")     THEN strMcpy(gonnrp,value,255); ENDIF;
      IF StrEqual(nom,"newsdbm")    THEN strMcpy(newsdbm,value,255); ENDIF;
      IF StrEqual(nom,"KilledGroups") THEN strMcpy(killedGroups,value,255); ENDIF;
      IF StrEqual(nom,"CacheFile")  THEN strMcpy(cachefile,value,255); ENDIF;
      ENDFORFILE
      
  RECOVER 
    char mess[255],dirname[255];
    sprintf(mess,"Can't open configfile %s/%s\n",getcwd(dirname,255),configFile);
    ServerError(mess);
  ENDRECOVER

   IF NOT StrEqual(logFileName,"*") THEN 
     LogMessage("Requested");
     ENDIF

  /* ======= COMMANDS ==== */

  /* ==== COMMANDS THAT DON't NETWORK nor uses ITEM ==== */
  WHILE StrEqual( "-f", option) DO
    FILE *CR;
    char title[80],*copyright;

    copyright= ShiftArgs();
    option=ShiftArgs();
    CR=fopen(copyright,"r");
    IF  CR == NULL THEN ServerError("No copyright file"); ENDIF
    fgets(title,80,CR);
    fclose(CR);
    Chop(title);
    printf("0%s\t%s\t%s\t%i\r\n",title,copyright,gopherHost,gopherPort);
    /* This command can be combined with others, so no return  */
    ENDWHILE

  IF StrEqual(option,"-B") THEN
    /* This takes 1 or more argumens from argv */
    Do_B();  
    return 0;
    ENDIF;
    
  /* ==== COMMANDS THAT DON't USES ITEM (group)  argument but NETWORK ==== */
  IF StrEqual(option,"-C") THEN
    fnntp=OpenNNTP();
    Do_C(fnntp);  
    CloseNNTP(fnntp);
    return 0;
    ENDIF
  
  /* ==== COMMANDS THAT USES ITEM (group) argument === */
  
  item=ShiftArgs();

  TRY /* Reading and matching killed groups */
    FORFILE_LINES(killedGroups,255)
      IF lonLine!=0 AND match(line, item) THEN
        char eMessage[255];
        sprintf(eMessage,"Gopher access to %s is not allowed",item);
        ServerError(eMessage);
        ENDIF   
      ENDFORFILE
  
  RECOVER 
    /* Ignore if no killfile */
  ENDRECOVER

  /* ==== COMMANDS THAT USES ITEM but NOT NETWORK === */

  IF NOT StrEqual(cachefile,"*") THEN
    IF StrEqual(option,"-g") OR StrEqual(option,"-G") THEN
      /* -G & -g commands uses cache, so open it instead of network */
      int cache; 

      cache=open( cachefile,O_RDONLY );
      IF cache<0 THEN ServerError("Can't open cachefile");  ENDIF
      SinitGets(cache);
    
      IF StrEqual(option,"-g") THEN
        Do_g(item, cache);  

      ELSIF StrEqual(option,"-G") THEN
        Do_G(item, cache);  
        ENDIF

      close(cache);  ScloseGets(cache);
      return 0;  
      ENDIF
    ENDIF
   
  /* ==== COMMANDS THAT USES NETWORK & ITEM ==== */

  fnntp=OpenNNTP();

  IF StrEqual(option,"-g") THEN
    Do_g(item, fnntp);  

  ELSIF StrEqual(option,"-G") THEN
    Do_G(item, fnntp);  

  ELSIF StrEqual(option,"-h") OR 
        StrEqual(option,"-b") OR 
        StrEqual(option,"-s") THEN
    char *lookup;
    lookup=ShiftArgs();
    Do_hbs(option,item, lookup, fnntp);  

  ELSIF StrEqual(option,"-a") THEN
    char *artnum,*bodyOpt;
    artnum=ShiftArgs(); bodyOpt=ShiftArgs();
    Do_a(item, artnum, bodyOpt, fnntp);  
  
  ELSIF StrEqual(option,"-l") THEN
    char *bodyOpt;
    bodyOpt=ShiftArgs();
    Do_l(item, bodyOpt, fnntp);  

  ELSIF StrEqual(option,"-T") THEN
    Do_T(item, fnntp);  

  ELSIF StrEqual(option,"-X") THEN
    /* This takes 2 or more argumens from argv */
    Do_X(item, fnntp);  

    ENDIF

  CloseNNTP(fnntp);
  
  return(0);
  
RECOVER
  ServerError("Fatal Server Error");
ENDRECOVER  
}


